def __account_export(brand_key):
    # import csv
    mysql_id='mysql'

    mysql = DFF.SRC(mysql_id)
    # userSql = '''select uuid, name, email from main_account where status=0 and email != '' and email not like '%@dataflux.cn' and email not like '%@guance.com' and email not like '%@jiagouyun.com' and email not like '%@prof.wang';'''
    userSql = f'''
        select
            uuid,
            name,
            email,
            mobile,
            (
                select
                    case count(*) when 0 then 'F' else 'T' end
                from main_workspace as ws
                inner join main_account_workspace as aw on ws.uuid = aw.workspaceUUID
                where
                    aw.accountUUID = acc.uuid
                    and ws.status = 0
                    and ws.versionType = 'pay'
                    and ws.billingState = 'normal'
            ) as business,
            (
                select
                    case count(*) when 0 then 'F' else 'T' end
                from biz_account_role as ar
                inner join main_account as ma on ma.uuid = ar.accountUUID
                inner join main_account_workspace as aw on ar.workspaceUUID = aw.workspaceUUID
                inner join main_workspace as ws on aw.workspaceUUID = ws.uuid
                where
                    ar.accountUUID = acc.uuid
                    and ar.status = 0
                    and ar.roleUUID in ('wsAdmin', 'owner')
                    and ws.versionType = 'pay'
                    and ws.billingState = 'normal'
            ) as isAdmin,
            FROM_UNIXTIME(acc.extend->'$.lastLoginTime') as lastLoginTime,
            case acc.extend->'$.unSubscribeRealTimeInfo' when 0 then 'F' else 'T' end as subscribe,
            FROM_UNIXTIME(acc.createAt) as createDate
        from main_account acc
        where
            acc.status=0
            and acc.email != ''
            and acc.brandKey = '{ brand_key }'
            and acc.email not like '%@dataflux.cn'
            and acc.email not like '%@prof.wang';
    '''

    accounts = mysql.query(userSql)

    csv_text = ["uuid,name,email,mobile,business,isAdmin,lastLoginTime,subscribe,createDate"]
    for acc in accounts:
        csv_text.append(acc["uuid"] + "," + acc["name"] + "," + acc["email"] + "," + acc["mobile"] + "," + acc["business"] + "," + acc["isAdmin"] + "," + str(acc["lastLoginTime"]) + "," + acc["subscribe"] + "," + str(acc["createDate"]))

    return "\n".join(csv_text)

@DFF.API('account export')
def account_export():
    return __account_export('guance')

@DFF.API('truewatch account export')
def truewatch_account_export():
    return __account_export('truewatch')
