import time
import json
import requests
from requests.adapters import HTTPAdapter, Retry


workspace_uuid='wksp_system'
datakit_id = 'datakit'
mysql_id='mysql'
# datakit_id = 'datakit'
# mysql_id='mysql'


# 脚本中的使用量统计方式以及 可统计项参考文档： https://guanceyun.feishu.cn/wiki/I057w751AipHIpk8q27cFHJinKc

# 使用量 DQL 查询中 每种聚合字段类型对应的 过滤条件
FIELTER_FORMAT = {
    "sum(count)": "project=\"{}\", count != 0",
    "max(count)": "project=\"{}\", count != 0",
    "sum(hour_count) as count": "project=\"{}\", hour_count != 0",
}

# 使用量统计中，每个统计项 对应的聚合字段 聚合方法
USAGE_DQL_MAPPING = {
    #
    "timeseries": "max(count)",
    "job_runs": "sum(hour_count) as count",
    "sms": "sum(hour_count) as count",

    "rum_pv": "max(count)",
    "datakit": "max(count)",

    "logging": "sum(hour_count) as count",
    "tracing": "sum(hour_count) as count",
    "synthetic_test_runs": "sum(hour_count) as count",
}

@DFF.API('df_biz_workspace', timeout=500)
def df_biz_workspace():
    all_workspace = get_all_workspace()
    member_count = get_member_count()
    member_login_count = get_member_login_count()
    rum_app_count = get_rum_app_count()
    monitor_check_count = get_monitor_check_count()
    usage_info = get_metering_data()
    dkData = []
    for i in all_workspace:
        try:
            wksp_uuid = i["workspaceUUID"]
            cur_usage = usage_info.get(wksp_uuid, {})

            tempData = {
                'measurement': 'df_biz_workspace',
                'tags': {
                    'uuid': i['workspaceUUID'],
                    'version': i['version'],
                    'name': i['name'],
                    'project': 'metering',
                    'tenant': str(i['id'])
                },
                'fields': {
                    'type': i['version'],
                    'rum_app_count': 0,
                    'member_count': member_count.get(wksp_uuid, 0),
                    'member_login_count': member_login_count.get(wksp_uuid, 0),
                    'monitor_check_count': monitor_check_count.get(wksp_uuid, 0),
                    'metering_log_count': cur_usage.get('logging', 0),
                    'metering_trace_count': cur_usage.get('tracing', 0),
                    'metering_rum_pv_count': cur_usage.get('rum_pv', 0),
                    'metering_job_count': cur_usage.get('job_runs', 0),
                    'metering_sms_count': cur_usage.get('sms', 0),
                    'metering_datakit_count': cur_usage.get('datakit', 0),
                    'metering_api_test_count': cur_usage.get('synthetic_test_runs', 0),
                    'metering_series_count': cur_usage.get('timeseries', 0),
                }
            }
            #print("--->>>", tempData)
            dkData.append(tempData)
        except Exception as e:
            print(i)
            print("error",e)

        if len(dkData) >= 100:
            # 每次最多上报一百条记录
            push_dk(dkData)
            dkData = []

    # 最后一波上传
    if len(dkData) > 0:
        push_dk(dkData)
    return


def dql_query(workspace_uuid, projects, startTime, endTime):
    result = {}
    for project in projects:
        field_str = USAGE_DQL_MAPPING[project]
        filter_str = FIELTER_FORMAT[field_str].format(project)
        dql = "metering::`*`:(" + field_str + ") {" + filter_str + "} by workspaceUUID"
        body ={
            "workspace_uuid": workspace_uuid,
            "queries": [
                {
                    "query": dql,
                    "qtype": "dql",
                    "slimit": 10000,
                    "tz": "Asia/Shanghai",
                    "time_range": [startTime, endTime],
                    "is_async": False,
                    "mask_visible": True
                }
            ],
            "echo_explain": True
        }
        # 请求的url地址
        url = 'http://kodo-inner.forethought-kodo:9527/v1/query'
        # url = 'http://testing-ft2x-kodo-inner-api.dataflux.cn/v1/query'
        # 请求头
        headers = {"content-type":"application/json"}
        # payload 为传入的参数
        payload = json.dumps(body)
        # json形式，参数用json
        # print(payload)
        res = requests.post(url,data=payload,headers=headers)
        try:
            content = res.json().get("content", [])
        except Exception as e:
            print(e)
            print(res.text)
            content = []

        if not content:
            continue

        for row in content[0].get("series", []) or []:
            wksp_uuid = row.get("tags", {}).get("workspaceUUID")
            if not wksp_uuid:
                continue

            count = row.get("values", [])[0][1]
            result.setdefault(wksp_uuid, {}).setdefault(project, count)

    return result


def get_all_workspace():
    mysql = DFF.SRC(mysql_id)
    # 获取uuid version
    info = '''select id,uuid as workspaceUUID,versionType as version, name  from main_workspace where status != 3;'''
    res = mysql.query(info)
    # for i in res:
    #     print(i['workspaceUUID'])
    return res

def get_member_count():
    mysql = DFF.SRC(mysql_id)
    # 获取uuid version
    data = '''select b.workspaceUUID,  count(a.uuid) as member_count \
           from main_account a \
           left join main_account_workspace b on a.uuid = b.accountUUID \
           where  a.status != 3 and b.status != 3  \
           group by b.workspaceUUID;'''
    res = mysql.query(data)
    result = {}
    if len(res) > 0:
        result = {x["workspaceUUID"]: x["member_count"] for x in res}
    return result

def get_member_login_count():
    # 2021.12.14 modified by lhm
    # 对齐到前一个小时整点时间戳
    # 且不同 project 的统计方式不同
    endTime = int(time.time()) // 3600 * 3600
    startTime = endTime - 3600

    mysql = DFF.SRC(mysql_id)
    # 获取uuid version
    data = '''select c.uuid as workspaceUUID,count(a.accountUUID) as member_login_count
              from biz_account_login_history a
              left join main_account_workspace b on a.accountUUID = b.accountUUID
              left join main_workspace c on b.workspaceUUID = c.uuid
              where  c.status != 3 and b.status != 3 and a.createAt >= %s and a.createAt < %s
              group by c.uuid;''' % (startTime, endTime)
    res = mysql.query(data)
    result = {}
    if len(res) > 0:
        result = {x["workspaceUUID"]: x["member_login_count"] for x in res}
    return result

def get_rum_app_count():
    mysql = DFF.SRC(mysql_id)
    # 获取uuid version
    data = '''select b.uuid,count(a.uuid) as rum_app_count \
            from biz_rum_cfg a \
            left join main_workspace b on b.uuid = a.workspaceUUID \
            where  b.status != 3 and a.status != 3  \
            group by b.uuid;'''
    res = mysql.query(data)
    result = {}
    if len(res) > 0:
        result = {x["uuid"]: x["rum_app_count"] for x in res}
    return result

def get_monitor_check_count():
    mysql = DFF.SRC(mysql_id)
    # 获取uuid version
    data = '''select b.uuid as workspaceUUID,count(a.uuid) as monitor_check_count
              from biz_rule a
              left join main_workspace b on b.uuid = a.workspaceUUID
              where  a.status != 3 and b.status != 3 \
              group by b.uuid;'''
    res = mysql.query(data)
    result = {}
    if len(res) > 0:
        result = {x["workspaceUUID"]: x["monitor_check_count"] for x in res}
    return result

def get_metering_data():
    # all_data = {}
    # workspaces = ['wksp_40a73c6c2b024301a0b1d139e756b61e']
    # 2021.12.14 modify by lhm
    # 对齐到前一个小时整点时间戳
    endTime = int(time.time()) // 3600 * 3600
    startTime = endTime - 3600
    projects = list(USAGE_DQL_MAPPING.keys())
    result = dql_query(workspace_uuid, projects, startTime * 1000, endTime * 1000)
    return result

def push_dk(data):
    datakit = DFF.SRC(datakit_id)
    # print(data)
    for i in data:
        print(i)
        try:
            res = datakit.write_metric(measurement=i['measurement'], tags=i['tags'], fields=i['fields'])
            print(res)
            print(1)
        except Exception as e:
            print(i)
            print(e)
        # print(res)
