import time

datakit_id = 'datakit'
mysql_id='mysql'

@DFF.API('df_biz_summary')
def df_biz_summary():
    push_dk(get_df_biz_summary())

def get_df_biz_summary():
    # 2021.12.14 modified by lhm
    # 对齐到前一个小时整点时间戳
    # 且不同 project 的统计方式不同
    endTime = int(time.time()) // 3600 * 3600
    startTime = endTime - 3600

    mysql = DFF.SRC(mysql_id)
    userSql = '''select count(1) as new_user_count, (select count(1) from main_account) as total_user_count from main_account where createAt >= %s and createAt < %s;''' % (startTime, endTime)
    new_all_workspace = '''select count(1) as new_workspace_count , \
       (select count(1) from main_workspace) as total_workspace_count \
        from main_workspace \
        where createAt >= %s and createAt < %s;''' % (startTime, endTime)

    free_workspace = '''select count(1) as free_workspace_count \
        from main_workspace \
        where versionType = 'free';'''
    pay_workspace = '''select count(1) as paying_workspace_count \
        from main_workspace \
        where versionType = 'pay';'''
    heart_beat = '''select count(accountId) as count, deviceOS from biz_account_device \
        where heartBeat >= %s and heartBeat < %s \
        group by deviceOS;''' % (startTime, endTime)
    data = {
        'measurement': 'df_biz_summary',
        'tags':{},
        'fields': {}
    }
    temp = []
    res = mysql.query(userSql)
    if len(res) > 0:
        data['fields']['new_user_count'] = res[0]['new_user_count']
        data['fields']['total_user_count'] = res[0]['total_user_count']
    res = mysql.query(new_all_workspace)
    if len(res) > 0:
        data['fields']['new_workspace_count'] = res[0]['new_workspace_count']
        data['fields']['total_workspace_count'] = res[0]['total_workspace_count']
    res = mysql.query(free_workspace)
    if len(res) > 0:
        data['fields']['free_workspace_count'] = res[0]['free_workspace_count']
    res = mysql.query(pay_workspace)
    if len(res) > 0:
        data['fields']['paying_workspace_count'] = res[0]['paying_workspace_count']
    res = mysql.query(heart_beat)
    if len(res) > 0:
        for i in res:
            data['tags']['device_os'] = i['deviceOS']
            data['fields']['device_heartbeat_count'] = i['count']
            temp.append(data)
    if len(temp) < 1:
        temp.append(data)
    return temp


def push_dk(data):
    datakit = DFF.SRC(datakit_id)
    res = datakit.write_metric_many(data)
    # res = datakit.write_metric(measurement=data['measurement'], tags={}, fields=data['fields'])
    print(res)